<?php
session_start();
error_reporting(E_ALL);
ini_set('display_errors', 1);
include('includes/dbconnection.php');

if (strlen($_SESSION['imsaid']) == 0) {
    header('location:logout.php');
} else {
    $success_message = '';
    $error_message = '';
    
    if (isset($_POST['submit'])) {
        $slidertitle = trim($_POST['slidertitle']);
        $sliderdescription = trim($_POST['sliderdescription']);
        $sliderlink = trim($_POST['sliderlink']);
        $sliderorder = intval($_POST['sliderorder']);
        $status = isset($_POST['status']) ? '1' : '0';
        
        if (empty($slidertitle)) {
            $error_message = "Slider title is required!";
        } else {
            // Create upload directory if it doesn't exist
            $upload_dir = 'images/slider/';
            if (!file_exists($upload_dir)) {
                mkdir($upload_dir, 0777, true);
            }
            
            // Handle file upload
            if (!empty($_FILES['slider_image']['name'])) {
                $file_name = $_FILES['slider_image']['name'];
                $file_tmp = $_FILES['slider_image']['tmp_name'];
                $file_size = $_FILES['slider_image']['size'];
                $file_ext = strtolower(pathinfo($file_name, PATHINFO_EXTENSION));
                $allowed_extensions = array('png', 'jpg', 'jpeg', 'gif');
                
                if (in_array($file_ext, $allowed_extensions)) {
                    if ($file_size < 5000000) { // 5MB limit
                        $new_file_name = 'slider_' . time() . '.' . $file_ext;
                        $upload_path = $upload_dir . $new_file_name;
                        
                        if (move_uploaded_file($file_tmp, $upload_path)) {
                            $slider_image = $new_file_name;
                            
                            // Insert into database
                            $query = mysqli_query($con, "INSERT INTO tblslider(SliderTitle, SliderImage, SliderDescription, SliderLink, SliderOrder, Status) VALUES('$slidertitle', '$slider_image', '$sliderdescription', '$sliderlink', '$sliderorder', '$status')");
                            
                            if ($query) {
                                $success_message = "Slider has been created successfully!";
                                echo "<script>alert('" . addslashes($success_message) . "');</script>";
                                echo "<script>window.location.href = 'manage-slider.php';</script>";
                            } else {
                                $error_message = "Database error: " . mysqli_error($con);
                                echo "<script>alert('" . addslashes($error_message) . "');</script>";
                            }
                        } else {
                            $error_message = "Failed to upload file!";
                        }
                    } else {
                        $error_message = "File size too large! Maximum 5MB allowed.";
                    }
                } else {
                    $error_message = "Invalid file type! Only PNG, JPG, JPEG, GIF allowed.";
                }
            } else {
                $error_message = "Please select an image file!";
            }
            
            if (!empty($error_message)) {
                echo "<script>alert('" . addslashes($error_message) . "');</script>";
            }
        }
    }
?>
<!DOCTYPE html>
<html lang="en">
<head>
<title>Mobile Store Management System|| Add Slider</title>
<?php include_once('includes/cs.php');?>
</head>
<body>

<!--Header-part-->
<?php include_once('includes/header.php');?>
<?php include_once('includes/sidebar.php');?>

<div id="content">
<div id="content-header">
  <div id="breadcrumb"> <a href="dashboard.php" title="Go to Home" class="tip-bottom"><i class="icon-home"></i> Home</a> <a href="add-slider.php" class="tip-bottom">Add Slider</a></div>
  <h1>Add Slider Image</h1>
</div>
<div class="container-fluid">
  <hr>
  <div class="row-fluid">
    <div class="span12">
      <div class="widget-box">
        <div class="widget-title"> <span class="icon"> <i class="icon-align-justify"></i> </span>
          <h5>Add Slider</h5>
        </div>
        <div class="widget-content nopadding">
          <form name="addslider" method="post" class="form-horizontal" enctype="multipart/form-data">
            <div class="control-group">
              <label class="control-label">Slider Title :</label>
              <div class="controls">
                <input type="text" class="span11" name="slidertitle" id="slidertitle" value="" required />
              </div>
            </div>
            <div class="control-group">
              <label class="control-label">Slider Image :</label>
              <div class="controls">
                <input type="file" class="span11" name="slider_image" id="slider_image" accept="image/*" required />
                <span class="help-block">Upload image (PNG, JPG, JPEG, GIF - Max 5MB)</span>
              </div>
            </div>
            <div class="control-group">
              <label class="control-label">Description :</label>
              <div class="controls">
                <textarea class="span11" name="sliderdescription" id="sliderdescription" rows="4"></textarea>
              </div>
            </div>
            <div class="control-group">
              <label class="control-label">Link URL :</label>
              <div class="controls">
                <input type="text" class="span11" name="sliderlink" id="sliderlink" value="" placeholder="e.g., shop-mobile.php" />
              </div>
            </div>
            <div class="control-group">
              <label class="control-label">Display Order :</label>
              <div class="controls">
                <input type="number" class="span11" name="sliderorder" id="sliderorder" value="1" min="1" />
              </div>
            </div>
            <div class="control-group">
              <label class="control-label">Status :</label>
              <div class="controls">
                <label class="checkbox">
                  <input type="checkbox" name="status" id="status" checked />
                  Active
                </label>
              </div>
            </div>
            <div class="form-actions">
              <button type="submit" class="btn btn-success" name="submit">Add Slider</button>
            </div>
          </form>
        </div>
      </div>
    </div>
  </div>
</div>
</div>

<!--Footer-part-->
<div class="row-fluid">
  <div id="footer" class="span12"> 2024 &copy; Mobile Store Management System. Brought to you by <a href="#">Admin</a> </div>
</div>

<!--end-Footer-part--> 
<?php include_once('includes/js.php');?>
</body>
</html>
<?php } ?>