<?php
include('includes/dbconnection.php');

echo "<h2>Database Debug Information</h2>";

// Check database connection
if (!$con) {
    echo "<p style='color: red;'>Database connection failed: " . mysqli_connect_error() . "</p>";
    exit;
}
echo "<p style='color: green;'>Database connection successful</p>";

// Check current database
$current_db = mysqli_query($con, "SELECT DATABASE()");
$db_name = mysqli_fetch_row($current_db)[0];
echo "<p>Current database: <strong>$db_name</strong></p>";

// Show all tables
echo "<h3>All Tables in Database:</h3>";
$tables = mysqli_query($con, "SHOW TABLES");
if (mysqli_num_rows($tables) > 0) {
    echo "<ul>";
    while ($table = mysqli_fetch_row($tables)) {
        echo "<li>" . $table[0] . "</li>";
    }
    echo "</ul>";
} else {
    echo "<p>No tables found</p>";
}

// Check specifically for tblslider
echo "<h3>Checking for tblslider table:</h3>";
$check_table = mysqli_query($con, "SHOW TABLES LIKE 'tblslider'");
if (mysqli_num_rows($check_table) > 0) {
    echo "<p style='color: green;'>tblslider table EXISTS</p>";
    
    // Show table structure
    echo "<h4>Table Structure:</h4>";
    $describe = mysqli_query($con, "DESCRIBE tblslider");
    if ($describe) {
        echo "<table border='1' style='border-collapse: collapse;'>";
        echo "<tr><th>Field</th><th>Type</th><th>Null</th><th>Key</th><th>Default</th><th>Extra</th></tr>";
        while ($row = mysqli_fetch_assoc($describe)) {
            echo "<tr>";
            echo "<td>" . $row['Field'] . "</td>";
            echo "<td>" . $row['Type'] . "</td>";
            echo "<td>" . $row['Null'] . "</td>";
            echo "<td>" . $row['Key'] . "</td>";
            echo "<td>" . $row['Default'] . "</td>";
            echo "<td>" . $row['Extra'] . "</td>";
            echo "</tr>";
        }
        echo "</table>";
        
        // Count records
        $count = mysqli_query($con, "SELECT COUNT(*) as total FROM tblslider");
        $total = mysqli_fetch_assoc($count)['total'];
        echo "<p>Total records in table: <strong>$total</strong></p>";
        
    } else {
        echo "<p style='color: red;'>Error describing table: " . mysqli_error($con) . "</p>";
    }
} else {
    echo "<p style='color: red;'>tblslider table does NOT exist</p>";
    
    // Try to create it
    echo "<h4>Attempting to create table...</h4>";
    $create_sql = "CREATE TABLE `tblslider` (
      `ID` int(11) NOT NULL AUTO_INCREMENT,
      `SliderTitle` varchar(255) NOT NULL,
      `SliderImage` varchar(255) NOT NULL,
      `SliderDescription` text DEFAULT NULL,
      `SliderLink` varchar(255) DEFAULT NULL,
      `SliderOrder` int(11) DEFAULT 1,
      `Status` int(11) DEFAULT 1,
      `CreationDate` timestamp NOT NULL DEFAULT current_timestamp(),
      PRIMARY KEY (`ID`)
    ) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4";
    
    if (mysqli_query($con, $create_sql)) {
        echo "<p style='color: green;'>Table created successfully!</p>";
        
        // Insert sample data
        $insert_sql = "INSERT INTO `tblslider` (`SliderTitle`, `SliderImage`, `SliderDescription`, `SliderLink`, `SliderOrder`, `Status`) VALUES
        ('Apple iPhone Collection', 'apple_slider_1.svg', 'Discover the latest iPhone models with cutting-edge technology', 'shop-mobile.php', 1, 1),
        ('Apple Watch Series', 'apple_slider_2.svg', 'Complete your Apple experience with premium accessories', 'shop-mobile.php', 2, 1)";
        
        if (mysqli_query($con, $insert_sql)) {
            echo "<p style='color: green;'>Sample data inserted successfully!</p>";
        } else {
            echo "<p style='color: orange;'>Warning: Could not insert sample data: " . mysqli_error($con) . "</p>";
        }
    } else {
        echo "<p style='color: red;'>Error creating table: " . mysqli_error($con) . "</p>";
    }
}

mysqli_close($con);
?>