<?php
session_start();
error_reporting(0);
include('includes/dbconnection.php');
if (strlen($_SESSION['imsaid']==0)) {
  header('location:logout.php');
  } else{

// Handle form submissions
if(isset($_POST['add_flash_sale'])) {
    $productId = $_POST['product_id'];
    $discountPercent = $_POST['discount_percent'];
    $startDate = $_POST['start_date'];
    $endDate = $_POST['end_date'];
    $isActive = isset($_POST['is_active']) ? 1 : 0;
    
    $query = mysqli_query($con, "INSERT INTO tblflashsale (ProductId, DiscountPercent, StartDate, EndDate, IsActive) VALUES ('$productId', '$discountPercent', '$startDate', '$endDate', '$isActive')");
    
    if($query) {
        echo "<script>alert('Flash sale added successfully');</script>";
    } else {
        echo "<script>alert('Something went wrong');</script>";
    }
}

if(isset($_POST['update_flash_sale'])) {
    $flashSaleId = $_POST['flash_sale_id'];
    $discountPercent = $_POST['discount_percent'];
    $startDate = $_POST['start_date'];
    $endDate = $_POST['end_date'];
    $isActive = isset($_POST['is_active']) ? 1 : 0;
    
    $query = mysqli_query($con, "UPDATE tblflashsale SET DiscountPercent='$discountPercent', StartDate='$startDate', EndDate='$endDate', IsActive='$isActive' WHERE ID='$flashSaleId'");
    
    if($query) {
        echo "<script>alert('Flash sale updated successfully');</script>";
    } else {
        echo "<script>alert('Something went wrong');</script>";
    }
}

if(isset($_GET['delete_id'])) {
    $deleteId = $_GET['delete_id'];
    $query = mysqli_query($con, "DELETE FROM tblflashsale WHERE ID='$deleteId'");
    
    if($query) {
        echo "<script>alert('Flash sale deleted successfully');</script>";
        echo "<script>window.location.href='flash-sale-management.php';</script>";
    }
}

?>
<!DOCTYPE html>
<html lang="en">
<head>
<title>Mobile Store Management System || Flash Sale Management</title>
<?php include_once('includes/cs.php');?>
<style>
.flash-sale-form {
    background: #fff;
    padding: 20px;
    border-radius: 8px;
    box-shadow: 0 2px 10px rgba(0,0,0,0.1);
    margin-bottom: 30px;
}

.flash-sale-table {
    background: #fff;
    border-radius: 8px;
    overflow: hidden;
    box-shadow: 0 2px 10px rgba(0,0,0,0.1);
}

.flash-sale-table table {
    width: 100%;
    border-collapse: collapse;
}

.flash-sale-table th,
.flash-sale-table td {
    padding: 12px;
    text-align: left;
    border-bottom: 1px solid #eee;
}

.flash-sale-table th {
    background: #f8f9fa;
    font-weight: 600;
}

.status-active {
    color: #28a745;
    font-weight: bold;
}

.status-inactive {
    color: #dc3545;
    font-weight: bold;
}

.btn-action {
    padding: 5px 10px;
    margin: 2px;
    border: none;
    border-radius: 4px;
    cursor: pointer;
    text-decoration: none;
    font-size: 12px;
}

.btn-edit {
    background: #007bff;
    color: white;
}

.btn-delete {
    background: #dc3545;
    color: white;
}

.form-group {
    margin-bottom: 15px;
}

.form-group label {
    display: block;
    margin-bottom: 5px;
    font-weight: 600;
}

.form-group input,
.form-group select {
    width: 100%;
    padding: 8px 12px;
    border: 1px solid #ddd;
    border-radius: 4px;
    font-size: 14px;
}

.checkbox-group {
    display: flex;
    align-items: center;
    gap: 8px;
}

.btn-primary {
    background: #007bff;
    color: white;
    padding: 10px 20px;
    border: none;
    border-radius: 4px;
    cursor: pointer;
    font-size: 14px;
}

.btn-primary:hover {
    background: #0056b3;
}
</style>
</head>
<body>

<?php include_once('includes/header.php');?>
<?php include_once('includes/sidebar.php');?>

<!--main-container-part-->
<div id="content">
<!--breadcrumbs-->
  <div id="content-header">
    <div id="breadcrumb"> 
        <a href="dashboard.php" title="Go to Home" class="tip-bottom"><i class="icon-home"></i> Home</a>
        <a href="#" class="current">Flash Sale Management</a>
    </div>
  </div>
<!--End-breadcrumbs-->

<div class="container-fluid">
    <div class="row-fluid">
        <div class="span12">
            
            <!-- Add Flash Sale Form -->
            <div class="flash-sale-form">
                <h3>Add New Flash Sale</h3>
                <form method="post">
                    <div class="row-fluid">
                        <div class="span6">
                            <div class="form-group">
                                <label>Select Product</label>
                                <select name="product_id" required>
                                    <option value="">Choose Product</option>
                                    <?php
                                    $products = mysqli_query($con, "SELECT * FROM tblproducts WHERE Status='1'");
                                    while($product = mysqli_fetch_array($products)) {
                                        echo "<option value='".$product['ID']."'>".$product['ProductName']."</option>";
                                    }
                                    ?>
                                </select>
                            </div>
                            
                            <div class="form-group">
                                <label>Discount Percentage</label>
                                <input type="number" name="discount_percent" min="1" max="90" required placeholder="e.g., 50">
                            </div>
                        </div>
                        
                        <div class="span6">
                            <div class="form-group">
                                <label>Start Date & Time</label>
                                <input type="datetime-local" name="start_date" required>
                            </div>
                            
                            <div class="form-group">
                                <label>End Date & Time</label>
                                <input type="datetime-local" name="end_date" required>
                            </div>
                            
                            <div class="form-group">
                                <div class="checkbox-group">
                                    <input type="checkbox" name="is_active" id="is_active" checked>
                                    <label for="is_active">Active</label>
                                </div>
                            </div>
                        </div>
                    </div>
                    
                    <button type="submit" name="add_flash_sale" class="btn-primary">Add Flash Sale</button>
                </form>
            </div>
            
            <!-- Flash Sales Table -->
            <div class="flash-sale-table">
                <h3 style="padding: 20px 20px 0;">Current Flash Sales</h3>
                <table>
                    <thead>
                        <tr>
                            <th>ID</th>
                            <th>Product</th>
                            <th>Discount %</th>
                            <th>Start Date</th>
                            <th>End Date</th>
                            <th>Status</th>
                            <th>Actions</th>
                        </tr>
                    </thead>
                    <tbody>
                        <?php
                        $flashSales = mysqli_query($con, "
                            SELECT fs.*, p.ProductName 
                            FROM tblflashsale fs 
                            LEFT JOIN tblproducts p ON fs.ProductId = p.ID 
                            ORDER BY fs.ID DESC
                        ");
                        
                        if(mysqli_num_rows($flashSales) > 0) {
                            while($sale = mysqli_fetch_array($flashSales)) {
                                $currentTime = date('Y-m-d H:i:s');
                                $isExpired = $currentTime > $sale['EndDate'];
                                $statusClass = ($sale['IsActive'] && !$isExpired) ? 'status-active' : 'status-inactive';
                                $statusText = ($sale['IsActive'] && !$isExpired) ? 'Active' : ($isExpired ? 'Expired' : 'Inactive');
                        ?>
                        <tr>
                            <td><?php echo $sale['ID']; ?></td>
                            <td><?php echo $sale['ProductName']; ?></td>
                            <td><?php echo $sale['DiscountPercent']; ?>%</td>
                            <td><?php echo date('M d, Y H:i', strtotime($sale['StartDate'])); ?></td>
                            <td><?php echo date('M d, Y H:i', strtotime($sale['EndDate'])); ?></td>
                            <td class="<?php echo $statusClass; ?>"><?php echo $statusText; ?></td>
                            <td>
                                <a href="#" onclick="editFlashSale(<?php echo $sale['ID']; ?>)" class="btn-action btn-edit">Edit</a>
                                <a href="?delete_id=<?php echo $sale['ID']; ?>" onclick="return confirm('Are you sure you want to delete this flash sale?')" class="btn-action btn-delete">Delete</a>
                            </td>
                        </tr>
                        <?php 
                            }
                        } else {
                            echo "<tr><td colspan='7' style='text-align: center; padding: 20px;'>No flash sales found</td></tr>";
                        }
                        ?>
                    </tbody>
                </table>
            </div>
            
        </div>
    </div>
</div>

</div>

<?php include_once('includes/footer.php');?>
<?php include_once('includes/js.php');?>

<script>
function editFlashSale(id) {
    // This would open a modal or redirect to edit page
    // For now, just alert
    alert('Edit functionality can be implemented with a modal or separate edit page');
}
</script>

</body>
</html>
<?php } ?>