// Flash Sale Countdown Timer
document.addEventListener('DOMContentLoaded', function() {
    // Set the date we're counting down to (4 hours 50 minutes from now)
    const now = new Date().getTime();
    const countDownDate = now + (4 * 60 * 60 * 1000) + (50 * 60 * 1000); // 4 hours 50 minutes

    // Update the countdown every 1 second
    const countdownTimer = setInterval(function() {
        // Get current date and time
        const currentTime = new Date().getTime();
        
        // Find the distance between now and the countdown date
        const distance = countDownDate - currentTime;
        
        // Time calculations for hours, minutes and seconds
        const hours = Math.floor((distance % (1000 * 60 * 60 * 24)) / (1000 * 60 * 60));
        const minutes = Math.floor((distance % (1000 * 60 * 60)) / (1000 * 60));
        const seconds = Math.floor((distance % (1000 * 60)) / 1000);
        
        // Display the result in the elements with corresponding IDs
        const hoursElement = document.getElementById("hours");
        const minutesElement = document.getElementById("minutes");
        const secondsElement = document.getElementById("seconds");
        
        if (hoursElement) hoursElement.innerHTML = hours.toString().padStart(2, '0');
        if (minutesElement) minutesElement.innerHTML = minutes.toString().padStart(2, '0');
        if (secondsElement) secondsElement.innerHTML = seconds.toString().padStart(2, '0');
        
        // Update the badge text as well
        const flashBadge = document.querySelector('.flash-sale-badge');
        if (flashBadge) {
            flashBadge.innerHTML = `Ends in ${hours.toString().padStart(2, '0')}:${minutes.toString().padStart(2, '0')}`;
        }
        
        // If the countdown is finished, write some text
        if (distance < 0) {
            clearInterval(countdownTimer);
            if (hoursElement) hoursElement.innerHTML = "00";
            if (minutesElement) minutesElement.innerHTML = "00";
            if (secondsElement) secondsElement.innerHTML = "00";
            if (flashBadge) flashBadge.innerHTML = "EXPIRED";
            
            // Optionally hide the flash sale section or show expired message
            const flashSection = document.querySelector('.flash-sale-section');
            if (flashSection) {
                flashSection.style.opacity = '0.6';
                const expiredMessage = document.createElement('div');
                expiredMessage.innerHTML = '<p style="text-align: center; color: #ef4444; font-weight: bold; margin-top: 20px;">Flash Sale has ended!</p>';
                flashSection.appendChild(expiredMessage);
            }
        }
    }, 1000);
});

// Add some interactive effects
document.addEventListener('DOMContentLoaded', function() {
    // Add hover effects to countdown items
    const countdownItems = document.querySelectorAll('.countdown-item');
    countdownItems.forEach(item => {
        item.addEventListener('mouseenter', function() {
            this.style.transform = 'scale(1.1)';
            this.style.transition = 'transform 0.2s ease';
        });
        
        item.addEventListener('mouseleave', function() {
            this.style.transform = 'scale(1)';
        });
    });
    
    // Add click effect to flash sale products
    const flashCards = document.querySelectorAll('.flash-product-card');
    flashCards.forEach(card => {
        card.addEventListener('click', function(e) {
            // Don't trigger if clicking on buttons
            if (!e.target.closest('.flash-product-actions')) {
                const productLink = this.querySelector('.flash-product-name a');
                if (productLink) {
                    window.location.href = productLink.href;
                }
            }
        });
    });
});